package ch.frankel.blog.spring.authoring.custom;

import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.w3c.dom.Element;

/**
 * Simplest bean definition parser. The bean has no attributes, the parser
 * generates an id.
 * 
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 */
public class SimplestBeanDefinitionParser extends AbstractSimpleBeanDefinitionParser {

	@Override
	protected Class<?> getBeanClass(Element element) {

		return Object.class;
	}
	
	@Override
	protected boolean shouldGenerateId() {

		return true;
	}
}
